/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.inferencing;

import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Index;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.JSNodeTypeInferrer;
import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.ParameterElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSObjectNode;
import com.aptana.js.internal.core.index.JSIndexWriter;
import com.aptana.js.internal.core.parsing.sdoc.model.DocumentationBlock;
import com.aptana.js.internal.core.parsing.sdoc.model.TagType;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSymbolTypeInferrer {
    private static final String NO_TYPE = "";
    private final Index index;
    private final JSScope activeScope;
    private final URI location;
    private final JSIndexWriter writer;
    private final JSIndexQueryHelper queryHelper;

    private static TypeElement generateType(JSPropertyCollection property, Set<String> types) {
        TypeElement result = new TypeElement();
        String name = null;
        List<JSNode> values = property.getValues();
        if (!CollectionsUtil.isEmpty(values)) {
            int i = values.size() - 1;
            while (i >= 0) {
                JSNode value = values.get(i);
                String candidate = JSTypeUtil.getName(value);
                if (!StringUtil.isEmpty((String)candidate)) {
                    name = candidate;
                    break;
                }
                --i;
            }
        }
        if (StringUtil.isEmpty(name)) {
            name = property.getQualifiedName();
        }
        if (StringUtil.isEmpty(name)) {
            name = JSTypeUtil.getUniqueTypeName();
        }
        result.setName(name);
        if (!CollectionsUtil.isEmpty(types)) {
            for (String superType : types) {
                result.addParentType(superType);
            }
        }
        return result;
    }

    public JSSymbolTypeInferrer(JSScope activeScope, Index index, URI location, JSIndexQueryHelper queryHelper) {
        this.index = index;
        this.activeScope = activeScope;
        this.location = location;
        this.queryHelper = queryHelper;
        this.writer = new JSIndexWriter();
    }

    private void applyDocumentation(PropertyElement property, JSPropertyCollection object, IProgressMonitor monitor) {
        if (property == null || object == null) {
            return;
        }
        LinkedList<JSNode> queue = new LinkedList<JSNode>();
        HashSet<JSNode> visitedSymbols = new HashSet<JSNode>();
        queue.addAll(object.getValues());
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)queue.size());
        while (!queue.isEmpty()) {
            sub.setWorkRemaining(queue.size());
            JSNode node = (JSNode)((Object)queue.poll());
            if (!visitedSymbols.contains((Object)node)) {
                IParseNode rhs;
                visitedSymbols.add(node);
                DocumentationBlock docs = node.getDocumentation();
                if (docs != null) {
                    JSTypeUtil.applyDocumentation(property, node, docs);
                    break;
                }
                if (property instanceof FunctionElement && node instanceof JSFunctionNode) {
                    FunctionElement functionElement = (FunctionElement)property;
                    JSFunctionNode functionNode = (JSFunctionNode)node;
                    for (IParseNode parameterNode : functionNode.getParameters()) {
                        ParameterElement parameterElement = new ParameterElement();
                        parameterElement.setName(parameterNode.getText());
                        parameterElement.addType("Object");
                        functionElement.addParameter(parameterElement);
                    }
                } else if (node instanceof JSIdentifierNode) {
                    String symbol = node.getText();
                    JSPropertyCollection p = this.getSymbolProperty(this.activeScope.getObject(), symbol);
                    if (p != null) {
                        for (JSNode value : p.getValues()) {
                            queue.offer(value);
                        }
                    }
                } else if (node instanceof JSAssignmentNode && (rhs = node.getLastChild()) instanceof JSNode) {
                    queue.offer((JSNode)rhs);
                }
            }
            sub.worked(1);
        }
    }

    private PropertyElement createPropertyElement(Set<String> types) {
        if (!CollectionsUtil.isEmpty(types)) {
            for (String type : types) {
                if (!JSTypeUtil.isFunctionPrefix(type)) continue;
                return new FunctionElement();
            }
        }
        return new PropertyElement();
    }

    private List<String> getAdditionalProperties(JSPropertyCollection activeObject, Set<String> types) {
        Map<String, PropertyElement> propertyMap = this.getTypePropertyMap(types);
        ArrayList<String> additionalProperties = new ArrayList<String>();
        for (String name : activeObject.getPropertyNames()) {
            if (propertyMap.containsKey(name) && !"prototype".equals(name)) continue;
            additionalProperties.add(name);
        }
        return additionalProperties;
    }

    public List<PropertyElement> getScopeProperties(IProgressMonitor monitor) {
        List<String> symbolNames = this.activeScope.getLocalSymbolNames();
        final SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)symbolNames.size());
        return CollectionsUtil.map(symbolNames, (IMap)new IMap<String, PropertyElement>(){

            public PropertyElement map(String symbol) {
                return JSSymbolTypeInferrer.this.getSymbolPropertyElement(symbol, (IProgressMonitor)sub.newChild(1));
            }
        });
    }

    private JSPropertyCollection getSymbolProperty(JSPropertyCollection activeObject, String symbol) {
        JSPropertyCollection property = activeObject.getProperty(symbol);
        if (property == null) {
            property = this.activeScope.getSymbol(symbol);
        }
        return property;
    }

    public PropertyElement getSymbolPropertyElement(JSPropertyCollection activeObject, String symbol, IProgressMonitor monitor) throws OperationCanceledException {
        JSPropertyCollection property = this.getSymbolProperty(activeObject, symbol);
        PropertyElement result = null;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        if (property != null) {
            if (property.hasElement()) {
                return property.getElement();
            }
            LinkedHashSet<String> types = new LinkedHashSet<String>();
            if (property.hasTypes()) {
                types.addAll(property.getTypes());
            } else {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.processValues(property, types, (IProgressMonitor)sub.newChild(10));
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.processProperties(property, types, (IProgressMonitor)sub.newChild(10));
            }
            sub.setWorkRemaining(30);
            result = this.createPropertyElement(types);
            if (!CollectionsUtil.isEmpty(types)) {
                int part = 20 / types.size();
                for (String typeName : types) {
                    if (sub.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    JSTypeUtil.applySignature(result, typeName);
                    sub.worked(part);
                }
            }
            sub.setWorkRemaining(10);
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.applyDocumentation(result, property, (IProgressMonitor)sub.newChild(10));
            property.setElement(result);
        } else {
            result = new PropertyElement();
        }
        result.setName(symbol);
        return result;
    }

    public PropertyElement getSymbolPropertyElement(String symbol, IProgressMonitor monitor) {
        return this.getSymbolPropertyElement(this.activeScope.getObject(), symbol, monitor);
    }

    private Map<String, PropertyElement> getTypePropertyMap(Set<String> types) {
        HashSet<String> ancestors = new HashSet<String>();
        for (String type : types) {
            ancestors.add(type);
            ancestors.addAll(this.queryHelper.getTypeAncestorNames(type));
        }
        ArrayList<String> typesAndAncestors = new ArrayList<String>(ancestors);
        Collection<PropertyElement> typeMembers = this.queryHelper.getTypeMembers(typesAndAncestors);
        HashMap<String, PropertyElement> propertyMap = new HashMap<String, PropertyElement>();
        for (PropertyElement propertyElement : typeMembers) {
            propertyMap.put(propertyElement.getName(), propertyElement);
        }
        return propertyMap;
    }

    public void processProperties(JSPropertyCollection property, Set<String> types, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (property.hasProperties()) {
            List<String> additionalProperties = this.getAdditionalProperties(property, types);
            if (!additionalProperties.isEmpty()) {
                TypeElement subType = JSSymbolTypeInferrer.generateType(property, types);
                sub.worked(5);
                ArrayList<String> returnTypes = new ArrayList<String>();
                if (!CollectionsUtil.isEmpty(types)) {
                    int unit = 20 / types.size();
                    for (String type : types) {
                        if (JSTypeUtil.isFunctionPrefix(type)) {
                            returnTypes.addAll(JSTypeUtil.getFunctionSignatureReturnTypeNames(type));
                        }
                        sub.worked(unit);
                    }
                }
                sub.setWorkRemaining(75);
                String propertyType = subType.getName();
                if (!JSTypeUtil.isFunctionPrefix(propertyType) && !returnTypes.isEmpty()) {
                    propertyType = String.valueOf(propertyType) + JSTypeUtil.toFunctionType(returnTypes);
                }
                types.clear();
                types.add(propertyType);
                property.addType(propertyType);
                if (!CollectionsUtil.isEmpty(additionalProperties)) {
                    PropertyElement pe;
                    JSPropertyCollection collection;
                    if (additionalProperties.contains("prototype") && (collection = property.getProperty("prototype")).hasProperties()) {
                        for (String pname : collection.getPropertyNames()) {
                            pe = this.getSymbolPropertyElement(collection, pname, (IProgressMonitor)new NullProgressMonitor());
                            pe.setIsInstanceProperty(true);
                            pe.setIsClassProperty(false);
                            subType.addProperty(pe);
                        }
                        additionalProperties.remove("prototype");
                    }
                    if (!CollectionsUtil.isEmpty(additionalProperties)) {
                        int work = 70 / additionalProperties.size();
                        for (String pname : additionalProperties) {
                            pe = this.getSymbolPropertyElement(property, pname, (IProgressMonitor)sub.newChild(work));
                            pe.setIsClassProperty(true);
                            subType.addProperty(pe);
                        }
                    }
                }
                if (subType.getProperty("prototype") == null) {
                    PropertyElement pe = new PropertyElement();
                    pe.setName("prototype");
                    pe.addType("Object");
                    pe.setIsClassProperty(true);
                    pe.setIsInstanceProperty(false);
                    subType.addProperty(pe);
                }
                sub.setWorkRemaining(5);
                this.writeType(subType);
                sub.worked(5);
            }
        } else {
            for (String typeName : types) {
                property.addType(typeName);
            }
        }
    }

    private void processValues(JSPropertyCollection property, Set<String> types, IProgressMonitor monitor) throws OperationCanceledException {
        List<JSNode> values = property.getValues();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)values.size());
        for (JSNode value : values) {
            TagType tagToCheck;
            if (sub.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean isFunction = value instanceof JSFunctionNode;
            DocumentationBlock docs = value.getDocumentation();
            TagType tagType = tagToCheck = isFunction ? TagType.RETURN : TagType.TYPE;
            if (docs == null || !docs.hasTag(tagToCheck)) {
                if (value instanceof JSObjectNode) {
                    types.add("Object");
                } else {
                    JSNodeTypeInferrer inferrer = this.getNodeInferrer(sub);
                    property.addType(isFunction ? "Function" : NO_TYPE);
                    inferrer.visit(value);
                    property.clearTypes();
                    types.addAll(inferrer.getTypes());
                }
            } else if (isFunction) {
                FunctionElement f = new FunctionElement();
                JSTypeUtil.applyDocumentation(f, value, docs);
                types.addAll(f.getSignatureTypes());
            } else {
                PropertyElement p = new PropertyElement();
                JSTypeUtil.applyDocumentation(p, value, docs);
                types.addAll(p.getTypeNames());
            }
            sub.worked(1);
        }
    }

    private JSNodeTypeInferrer getNodeInferrer(SubMonitor sub) {
        return new JSNodeTypeInferrer(this.activeScope, this.index, this.location, this.queryHelper, (IProgressMonitor)sub);
    }

    private void writeType(TypeElement type) {
        if (type != null) {
            for (PropertyElement property : type.getProperties()) {
                property.setHasAllUserAgents();
            }
            this.writer.writeType(this.index, type, this.location);
        }
    }
}

